package cn.ninegame.ad.demo.activity;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;

import androidx.annotation.Nullable;

import cn.ninegame.ad.demo.R;
import cn.ninegame.ad.demo.config.NGAdManagerHolder;
import cn.ninegame.ad.demo.util.Const;
import cn.ninegame.ad.demo.util.UIUtil;
import cn.sirius.nga.ad.NGAdBase;
import cn.sirius.nga.ad.NGAdError;
import cn.sirius.nga.ad.NGSplashAd;
import cn.sirius.nga.ad.NGSplashCloseType;
import cn.sirius.nga.config.AdPlacement;

/**
 * 融合demo，开屏广告使用示例。更多功能参考接入文档。
 * <p>
 * 开屏广告会在游戏开启时加载，拥有固定展示时间（一般为5秒），展示完毕后自动关闭并进入游戏主界面
 * <p>
 * 通常应该闪屏之后展示开屏广告
 * <p>
 * 注意1：每次加载的广告，只能展示一次
 * <p>
 * 注意2：由于部分ADN对尺寸的要求，宽高建议默认为match_parent，即全屏展示（部分ADN要求手机屏幕的95%以上）
 * <p>
 * 注意3：不要有遮挡物，否则影响广告结算
 * <p>
 * 接入步骤：
 * 1、创建AdPlacement对象
 * 2、创建NGAdBase对象
 * 3、创建加载、展示监听器
 * 4、加载广告
 * 5、加载并渲染成功后，展示广告
 * 6、在onDestroy中销毁广告
 */
public class MediationSplashActivity extends Activity {

    /**
     * 开屏广告容器
     * <p>
     * 不要有遮挡物，否则影响广告结算
     * <p>
     * 宽高默认为match_parent，即全屏展示（部分ADN要求手机屏幕的95%以上）
     * <p>
     * 1. 容器类型不限制；2. 常见错误是 *.LayoutParams 与 容器不匹配，如更改容器请注意检查
     */
    private FrameLayout mSplashContainer;

    /**
     * 开屏广告对象
     */
    private NGSplashAd mSplashAd;

    /**
     * 广告加载监听器
     */
    private NGAdBase.SplashAdListener mNGSplashAdListener;

    /**
     * 广告展示监听器
     */
    private NGSplashAd.SplashAdListener mNGSplashInteractionListener;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.mediation_activity_splash);
        mSplashContainer = findViewById(R.id.fl_content);

        // 加载并展示广告
        loadAndShowSplashAd();
    }

    private void loadAndShowSplashAd() {
        /** 1、创建AdPlacement对象 */
        AdPlacement adPlacement = new AdPlacement.Builder()
                // 融合广告位（在NG平台的广告位，注意不是adn的代码位）
                .setCodeId(getResources().getString(R.string.splash_media_id))
                .setImageAcceptedSize(UIUtil.getScreenWidthInPx(this), UIUtil.getScreenHeightInPx(this))
                .build();

        /** 2、创建NGAdBase对象 需要传activity，切记!!*/
        NGAdBase adBaseLoader = NGAdManagerHolder.get().createAdNative(this);

        /** 3、创建加载、展示监听器 */
        initListeners();

        /** 4、加载广告 */
        /** 请求广告前，建议判断一次是否有网络，特别是激励广告 */
        adBaseLoader.loadSplashAd(
                adPlacement,
                mNGSplashAdListener,
                /* milliseconds，fetchDelay 取值范围为[1500, 5000]ms  */ 3500);
    }

    private void initListeners() {
        // 广告加载监听器
        this.mNGSplashAdListener = new NGAdBase.SplashAdListener() {
            @Override
            public void onSplashRenderSuccess(NGSplashAd ad) {
                /** 5、渲染成功后，展示广告 */
                Log.d(Const.TAG, "splash render success");

                if (ad != null) {
                    /** 获取 Splash 广告对象 */
                    mSplashAd = ad;
                    /** load成功后，先判断广告是否isReady，如果为false 可间隔一段时间再判断*/
                    if (ad.getMediationManager() != null && ad.getMediationManager().isReady()) {
                        ad.setSplashAdListener(mNGSplashInteractionListener);
                        View splashView = ad.getSplashView();

                        UIUtil.removeFromParent(splashView);
                        mSplashContainer.removeAllViews();

                        /** 宽高默认为match_parent，即全屏展示（部分ADN要求手机屏幕的95%以上） */
                        /** 不要有遮挡物，否则影响广告结算 */
                        mSplashContainer.addView(splashView);
                    }
                }
            }

            @Override
            public void onSplashLoadSuccess(NGSplashAd ad) {
                // 广告加载成功
                Log.d(Const.TAG, "splash load success");
            }

            @Override
            public void onSplashLoadFail(NGAdError ngAdError) {
                /** code = 900400、3003：网络不可用，无法连接到服务器。*/
                Log.d(Const.TAG, "splash load fail, errCode: " + ngAdError.getCode() + ", errMsg: " + ngAdError.getMsg());
            }

            @Override
            public void onSplashRenderFail(NGSplashAd ad, NGAdError ngAdError) {
                // 广告渲染失败
                Log.d(Const.TAG, "splash render fail, errCode: " + ngAdError.getCode() + ", errMsg: " + ngAdError.getMsg());
            }
        };

        // 广告展示监听器
        this.mNGSplashInteractionListener = new NGSplashAd.SplashAdListener() {
            @Override
            public void onSplashAdShow(NGSplashAd ad) {
                Log.d(Const.TAG, "splash show");
                // 开屏广告开始展示
            }

            @Override
            public void onSplashAdClick(NGSplashAd ad) {
                Log.d(Const.TAG, "splash click");
                /** 监听到广告点击事件，暂缓下一步逻辑，展示点击结果页面 */
                /** 用户点击广告时，建议不要主动关闭开屏广告，即 mSplashContainer.removeAllViews() 或其他关闭广告的操作 */
                /** 不要干扰广告流程，开屏广告关闭或结束，可监听 onSplashAdClose 里的事件来处理后续流程*/
            }

            @Override
            public void onSplashAdClose(NGSplashAd ad, int closeType) {

                if (closeType == NGSplashCloseType.CLICK_SKIP) {
                    Log.d(Const.TAG, "开屏广告点击跳过");

                } else if (closeType == NGSplashCloseType.COUNT_DOWN_OVER) {
                    Log.d(Const.TAG, "开屏广告点击倒计时结束");

                } else if (closeType == NGSplashCloseType.CLICK_JUMP) {
                    Log.d(Const.TAG, "点击跳转");
                }
                /** 开屏广告展示结束，游戏处理下一步流程，比如进入游戏主界面等*/
                /** 上述关闭类型，都是‘关闭’开屏广告，包括用户主动或展示完成自动关闭*/
                finish();
            }
        };
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        /** 6、在onDestroy中销毁广告 */
        if (mSplashAd != null && mSplashAd.getMediationManager() != null) {
            mSplashAd.getMediationManager().destroy();
        }
    }
}